#include "Map.h"

Map::Map() {

	//creates the room
	Room* p1 = new Room("\nGloomy Entrance", "\nYou find yourself in a dimly lit stone chamber with damp walls.\nFlickering torches cast eerie shadows. Three paths lie ahead: \na narrow stone door to the north, an archway leading into darkness to the east, \nand a rugged passage descending southwards.");
	m_pStart = p1;

	Room* p2 = new Room("\nArmory of the Fallen", "This chamber smells of rust and decay. Ancient weapons and broken armor are strewn around.\nA doorway to the south leads back to where you came.");
	Room* p3 = new Room("\nEndless Hallway", "The walls are lined with faded portraits whose eyes seem to follow you.\nShadows dance along the length of the corridor. To the west is the entrance chamber, \nwhile there is also a door to the east.");
	Room* p4 = new Room("\nAbandoned Camp", "\nTorn tents and cold campfires mark the remnants of those who once sought shelter here.\nThe only exit is the rough path you came from which lies north.");
	Room* p5 = new Room("\nBarracks of the Lost", "The scent of mildew fills the air as rows of abandoned cots lie untouched, draped in dust. \nTo the west is the endless hallway, a old wood door is to the south, and two grandiose looking doors are to the north.");
	Room* p6 = new Room("\nStorage Room", "Crates and barrels stacked precariously, some toppled over. \nDust swirls in the air as you step in. the only exit is the old wooden door you came from to the south");
	Room* p7 = new Room("\nHaunted Bedroom", "A chilling draft sweeps through this once-grand chamber. \nA colossal, four-poster bed, draped in tattered silk, dominates the room. \nBroken furniture and shattered mirrors litter the floor, reflecting eerie, distorted images. \nA faint, mournful wail echoes through the room, a chilling reminder of the tragic events that unfolded here. \nA door to the east and another to the north offer potential escape routes.");
	Room* p8 = new Room("\nOld Library", "The air is thick with the scent of old parchment. Rows of decaying bookshelves tower above you, filled with forgotten knowledge. \nThe only way out is through the door back west, or a hidden doorway to the south.");
	Room* p9 = new Room("\nHidden Study", "A cozy room filled with alchemical ingredients and strange scrolls.\nOld potions rests on a small wooden table but none of them seem to be usable. \nAn ancient door to the north opens into the libary or a vault door to the south.");
	Room* p10 = new Room("\nTreasures Room", "A vast chamber filled with glittering treasures and ancient artifacts.\nBut be wary, an ominous magical aura warns you not to take anything.\nThe exits are the vault door to the north, A door to the south with the mural of clouds and the sky, \nand ornate doors to the east, these doors depict a nice valley with a flowing river in the middle of it.");
	Room* p11 = new Room("\nForgotten Shrine", "A small, serene space, with a statue of a long-forgotten deity.\nThe air is heavy with an indescribable energy.\nThere is only the door to the north of you as an exit.");
	Room* p12 = new Room("\nHall of Echoes", "As you step in, your footsteps echo in a haunting manner.\nWater drips sporadically from the high ceiling, amplifying the stillness. \nThere is also a large pile of gold in this room and on this pile you see the Crimson Dragon.");


	// creates the puzzles
	p5->pRoomPuzzle = new Puzzle("You heard me before, yet you hear me again. Then I die, 'til you call me again. What am I?", "echo");
	p5->puzzleSolved = false;

	p9->pRoomPuzzle = new Puzzle("The more of this there is, the less you see. What is it?", "darkness");
	p9->puzzleSolved = false;

	p11->pRoomPuzzle = new Puzzle("I fly without wings, I cry without eyes. Whenever I go, darkness flies. What am I?", "cloud");
	p11->puzzleSolved = false;

	p12->pRoomPuzzle = new Puzzle("I can run but never walk, I have a mouth but never talk. What am I?", "river");
	p12->puzzleSolved = false;

	// creates the items
	p1->roomInventory.push_back(Item("torch", " - This torch will light the way."));

	p2->roomInventory.push_back(Item("sword", " - Adds +5 to attack. use the command USE to equip."));
	p4->roomInventory.push_back(Item("health potion", " - Heals the player for 20 Hp."));
	p4->roomInventory.push_back(Item("crumpled note", " - This note has the following text. -- I have found this following hint for the riddle further in this dungeon the hint is. Its something you can hear but never see. Through my testing of words, I think it is an echo. \n-SM --\n"));

	p5->roomInventory.push_back(Item("armor", " - Adds +5 to defense. use the command USE to equip."));

	p6->roomInventory.push_back(Item("old note", " - This note has the following written on it -- It is found at night go. \nto go past the libary you must find what it is. \n-SM --"));


	p10->roomInventory.push_back(Item("shield", " - Adds +2 to defense. use the command USE to equip."));

	p11->roomInventory.push_back(Item("health potion", " - Heals the ploayer for 20 HP."));

	// creates the Monsters

	p2->pRoomMonster = new Monster("Skeletal Guardian", "A towering skeletal figure, clad in remnants of ancient armor, guards the depths of this chamber.\nIts hollow eyes glow with an eerie blue light as it swings a rusty greatsword. \nA chilling aura surrounds it, warning of its deadly intent.", 20, 3);
	p2->isMonsterThere = true;

	p7->pRoomMonster = new Monster("Spectral Wraith", "A translucent figure, barely visible in the dim light, drifts through the room. \nIts mournful wails echo through the chamber, sending chills down your spine. \nThis spectral being, once a noble soul, now seeks vengeance upon intruders.", 40, 7);
	p7->isMonsterThere = true;

	p12->pRoomMonster = new Monster("Crimson Dragon", "A colossal, fire-breathing dragon, its scales shimmering with iridescent hues, guards the heart of the dungeon. \nIts deafening roar echoes through the cavern, shaking the very foundations. \nA hoard of treasure, guarded by this fearsome beast, awaits the brave adventurer who dares to challenge it.", 120, 13);
	p12->isMonsterThere = true;


	//assigns the rooms into either the north, east, south, or west so that the link list is built.
	p1->pNorth = p2;
	p1->pEast = p3;
	p1->pSouth = p4;

	p2->pSouth = p1;
	p3->pWest = p1;
	p4->pNorth = p1;

	p3->pEast = p5;
	p5->pWest = p3;
	p5->pNorth = p7;
	p5->pSouth = p6;

	p6->pNorth = p5;
	p7->pSouth = p5;
	p7->pEast = p8;

	p8->pWest = p7;
	p8->pSouth = p9;

	p9->pNorth = p8;
	p9->pSouth = p10;

	p10->pNorth = p9;
	p10->pEast = p12;
	p10->pSouth = p11;

	p11->pNorth = p10;

	p12->pWest = p10;



}

Map::~Map() {
	// deletes the rooms, puzzles, and monsters when the game is finished.

	delete m_pStart->pEast->pEast->pNorth->pEast->pSouth->pSouth->pEast->pRoomMonster;
	delete m_pStart->pEast->pEast->pNorth->pRoomMonster;
	delete m_pStart->pNorth->pRoomMonster;

	delete m_pStart->pEast->pEast->pNorth->pEast->pSouth->pSouth->pEast->pRoomPuzzle; // delete p12 puzzle
	delete m_pStart->pEast->pEast->pNorth->pEast->pSouth->pSouth->pEast; // p12
	delete m_pStart->pEast->pEast->pNorth->pEast->pSouth->pSouth->pSouth->pRoomPuzzle; // delete p11 puzzle
	delete m_pStart->pEast->pEast->pNorth->pEast->pSouth->pSouth->pSouth; // p11
	delete m_pStart->pEast->pEast->pNorth->pEast->pSouth->pSouth; // p10
	delete m_pStart->pEast->pEast->pNorth->pEast->pSouth->pRoomPuzzle; // delete p9 puzzle
	delete m_pStart->pEast->pEast->pNorth->pEast->pSouth; // p9	
	delete m_pStart->pEast->pEast->pNorth->pEast; // p8
	delete m_pStart->pEast->pEast->pNorth; // p7
	delete m_pStart->pEast->pEast->pSouth; // p6
	delete m_pStart->pEast->pEast->pRoomPuzzle; // delete p5 puzzle
	delete m_pStart->pEast->pEast; // p5
	delete m_pStart->pNorth; // p2

	delete m_pStart->pSouth; // p4
	delete m_pStart->pEast;  // p3

	delete m_pStart; // p1
}